// Уникальное имя кеша
const CACHE_NAME = 'my-ticket-page'

// Обработчик соединения страницы с воркером
self.addEventListener('install', e => {
  e.waitUntil(
    // Создаём кеш с уникальным именем и кешируем нужные файлы, пути относительно корня сайта
    caches
      .open(CACHE_NAME)
      .then(cache => cache.addAll([
        '/index.html', 
        '/style.css', 
        '/qr.svg'
      ]))
      .then(() => self.skipWaiting())
  )
})

// Обработчик запросов ресурсов со страницы
self.addEventListener('fetch', e => {
  e.respondWith(
    // Проверяем, есть ли запрашиваемый ресурс в кеше
    caches.match(e.request).then(cachedResponse => {
      // Если ресурс есть в кеше, берём оттуда
      if (cachedResponse) return cachedResponse

      // Если ресурс не в кеше, остаётся пробовать получить его по сети
      return fetch(e.request).then(netResponse => {
        if (netResponse.ok) {
          caches.open(CACHE_NAME).then(cache => 
            cache.put(e.request, netResponse.clone())
          )
        }
        return netResponse
      })
    })
  )
})
